IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='Val_Tarjetas_Lotes_Reten' AND xtype='U')
BEGIN
	/*Tabla creada a partir de la cola de memoria QR:Retenciones de APP: FSER.APP, Proc: Lotes:Tarjetas:Fac, Routine: Calcular_Retenciones*/
	CREATE TABLE Val_Tarjetas_Lotes_Reten
	(
		Id_Tar_Lote_Reten			INT NOT NULL IDENTITY(1,1),
		Id_Tar_Lote					INT,
		Id_Cliente					INT,
		Id_Trans					INT,									/*NO tiene FK (Gabriel)*/
		Id_Tipo_Reten				VARCHAR(10),
		Imp_Pago_Acum				DECIMAL(16,2),
		Imp_No_Imponible			DECIMAL(16,2),
		Imp_Base_Imponible			DECIMAL(16,2),
		Porc						DECIMAL(7,4),
		Imp_Determinado				DECIMAL(16,2),
		Imp_Reten_Ant				DECIMAL(16,2),
		Reten_Sobre					CHAR(6)
	)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Val_Tarjetas_Lotes_Reten' AND xtype='U')
BEGIN
	ALTER TABLE Val_Tarjetas_Lotes_Reten ADD CONSTRAINT PK_VTLR_PorId PRIMARY KEY CLUSTERED (Id_Tar_Lote_Reten)	
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Val_Tarjetas_Lotes_Reten' AND xtype='U')
BEGIN
	CREATE INDEX IX_VTLR_PorId_Tar_Lote ON Val_Tarjetas_Lotes_Reten (Id_Tar_Lote)	
	ALTER TABLE Val_Tarjetas_Lotes_Reten ADD CONSTRAINT FK_VTLR_Val_Tarjetas_Lotes FOREIGN KEY (Id_Tar_Lote) REFERENCES Val_Tarjetas_Lotes (Id_Tar_Lote)

	CREATE INDEX IX_VTLR_PorId_Cliente ON Val_Tarjetas_Lotes_Reten (Id_Cliente)	
	ALTER TABLE Val_Tarjetas_Lotes_Reten ADD CONSTRAINT FK_VTLR_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)

	CREATE INDEX IX_VTLR_PorId_Tipo_Reten ON Val_Tarjetas_Lotes_Reten (Id_Tipo_Reten)	
	ALTER TABLE Val_Tarjetas_Lotes_Reten ADD CONSTRAINT FK_VTLR_Cbtes_Reten_Tipos FOREIGN KEY (Id_Tipo_Reten) REFERENCES Cbtes_Reten_Tipos (Id_Tipo_Reten)
END
GO
